# Redfish Aggregation

With Redfish aggregation the host BMC aggregates resources from specified
satellite BMCs. Aggregated resources are accessed in the same way as local
resources. The only observable difference between local and aggregated resources
is aggregated resources have a special prefix added to their URIs.

The satellite BMCs are not aware that they are being aggregated. The aggregating
BMC handles the additional processing required to allow the aggregating BMC and
satellite BMCs to be observable as a singular combined BMC.

## Configuration

bmcweb by default is compiled with Redfish aggregation disabled. To enable it
add the following to your local.conf.

```bash
EXTRA_OEMESON:pn-bmcweb:append = "-Dredfish-aggregation='enabled'"
```

In addition to the compiler option, bmcweb requires a satellite config to be
present on D-Bus. The config contains the necessary information to connect to a
satellite BMC. The following is an example entity-manager json config for a
satellite located at 160.80.40.20:80

```bash
{
    "Exposes": [
        {
            "Hostname": "160.80.40.20",
            "Port": "80",
            "Name": "sat0",
            "Type": "SatelliteController",
            "AuthType": "None"
        }
    ],
```

Note that the satellite config must specify a hostname, port, and authentication
type. Currently the only type of supported authentication is "None". Bmcweb will
reject satellite configs that do not comply with these requirements.

## Satellite BMC Restrictions

- HTTP only connection to satellite BMC
- No authentication on satellite BMC
- Each satellite BMC must have a unique "Name" property in its configuration

## Supported Resources

Aggregation is supported for all resources that are currently supported by
bmcweb and appear under top level collections. A top level collection is the
first collection reached when walking the path from the service root. The
following are a few examples of top level collections:

```bash
/redfish/v1/Chassis
/redfish/v1/TaskService/Tasks
/redfish/v1/UpdateService/FirmwareInventory

```

The only exception is `/redfish/v1/JsonSchemas`. We purposefully do not
aggregate that collection since some of the schemas can be very large and their
versions could differ from the schema versions on the aggregating BMC. Instead
it is assumed that the schemas are compatible.

Similarly, we do not aggregate any satellite `$metadata` which is available at
`/redfish/v1/$metadata`. We make the assumption that the $metadata of the
aggregating BMC is compatible with all aggregated satellite resources.

Complete support needs to be added for all top level resource collections that
are defined in the Redfish spec, but are not yet supported by bmcweb. Queries to
these endpoints like `/redfish/v1/<unsupported_collection>` will return all
resources on the satellite BMC, but a link for the unsupported collection will
not appear when querying the Service Root.

## Operation

Aggregated resources will have a prefix appended to their URIs in order to
distinguish them from resources that are local to the aggregating BMC. The
prefix is derived from the "Name" property specified in the satellite BMC's
configuration in Entity Manager. This allows for meaningful and unique prefixes
for each satellite BMC.

The general URI format for aggregated resources is

```bash
/redfish/v1/<resource_collection>/<name>_<resource_id>
```

Where `<name>` is the value of the "Name" property from the satellite's
configuration. For example, if a satellite is configured with `"Name": "sat0"`,
its resources would appear as `/redfish/v1/Systems/sat0_system`.

### Aggregating Collections

Requests to top level collections are locally processed like normal by the
aggregating BMC. In addition, the request is forwarded to the satellite BMCs as
long as it was a GET request. Any other types of request is still handled
locally, but the aggregator will not forward it to the satellites.

The responses are processed by first adding the aggregation prefix to the URIs
and then adding the URIs to the "Members" array in the response generated by the
aggregating BMC.

If the responses from the satellite responses do not contain a "Members" array
then we assume the initial request was not actually for a top level collection
and we do not attempt to add anything to the response generated by the
aggregating BMC. Similarly, we ignore any satellite responses that do not return
a 200 response code.

The following example shows how aggregated resources are added to a top level
collection

```bash
curl -k -H "X-Auth-Token: $token" https://${bmc}/redfish/v1/Systems
{
  "@odata.id": "/redfish/v1/Systems",
  "@odata.type": "#ComputerSystemCollection.ComputerSystemCollection",
  "Members": [
    {
      "@odata.id": "/redfish/v1/Systems/system"
    },
    {
      "@odata.id": "/redfish/v1/Systems/sat0_system"
    },
    {
      "@odata.id": "/redfish/v1/Systems/sat1_system"
    }
  ],
  "Members@odata.count": 3,
  "Name": "Computer System Collection"
}
```

### Aggregating a Resource

When the request is for a singular satellite resource instead of a top level
collection, the aggregator will forward all types of requests (GET, POST,
DELETE, etc.). This is different from aggregating a collection where only GET
requests are forwarded to satellites.

Requests for aggregated resources are not fully processed by the aggregating
BMC. These requests are identified by the presence of the aggregation prefix in
the request's URI.

The following steps are used to retrieve the requested aggregated resource:

1. Determine the target satellite BMC based on the prefix
2. Remove the prefix from the response URI
3. Forward the request to the satellite BMC
4. Where appropriate add the prefix to the URIs in the response
5. Return the updated response from the satellite BMC

```bash
curl -k -H "X-Auth-Token: $token" https://${bmc}/redfish/v1/Systems/sat0_system
    {
        "@odata.id" :
            "/redfish/v1/Systems/sat0_system",
            ... "LogServices" :
            {"@odata.id" : "/redfish/v1/Systems/sat0_system/LogServices"},
            "Memory" :
            {"@odata.id" : "/redfish/v1/Systems/sat0_system/Memory"},
            ...
    }
```

We consider any response to be a valid response code from the satellite BMC. The
aggregator will attempt to perform prefix fixing on the received response and
then forward it to the client. It is up to the client to determine how to react
to the received response (e.g. resend the request). A failure during the
communication process will cause bmcweb to attempt to resend the request as per
the retry policy. Exhausting the retry policy will result in the aggregating BMC
returning a 502 response.

## Remaining Work

The long term goal is to have Redfish aggregation be enabled by default. There
are some features that must still be implemented before that can happen.

1. Add links to satellite only collections in responses from service root and
   other appropriate locations
2. Support HTTPS connection to satellite BMC

Support for the following items should be added as well. However, their
implementation is not a requirement to being able to enable Redfish aggregation
by default.

1. Support adding a Contains/ContainedBy relationship between local and
   aggregated Chassis.
2. Support Authentication with satellite BMCs
