OpenBMC UBI Code Update
==============

Two BMC Code Updates layouts are available:

 * Static, non-UBI layout - The default code update

 * UBI layout - enabled via obmc-ubi-fs machine feature

This document describes the UBI code update. The non-UBI code update can be
found here: [code-update.md](code-update.md)

### Steps to Update

The following are the steps to update the BMC if the UBI layout is enabled.

1. Get a UBI BMC image tar:
After building OpenBMC, you will end up with a set of image files in
`tmp/deploy/images/<platform>/`. `obmc-phosphor-image-<platform>.ubi.mtd.tar` is
the UBI BMC tar image. The UBI BMC tar image contains 5 files: u-boot,
kernel, ro, and rw partitions and the MANIFEST file, which contains information
about the image such as the image purpose and version. A MANIFEST file might
look like
```
purpose=xyz.openbmc_project.Software.Version.VersionPurpose.BMC
version=v1.99.10
```

2. Transfer the generated UBI BMC image to the BMC via one of the following
methods:
  * Method 1: Via scp: Copy the generated UBI BMC image to the `/tmp/images/`
    directory on the BMC.
  * Method 2: Via REST Upload:
  https://github.com/openbmc/docs/blob/master/rest-api.md#uploading-images
  * Method 3: Via TFTP: Perform a POST request to call the `DownloadViaTFTP`
    method of `/xyz/openbmc_project/software`.

3. Note the version id generated for that image file. The version id is a hash
value of 8 hexadecimal numbers, generated by SHA-512 hashing the version
string contained in the image and taking the first 8 characters. Get the
version id via one of the following methods:

  * Method 1: From the BMC command line, note the most recent directory name
    created under `/tmp/images/`, in this example it'd be `2a1022fe`:

      ```
      # ls -l /tmp/images/
      total 0
      drwx------    2 root     root            80 Aug 22 07:54 2a1022fe
      drwx------    2 root     root            80 Aug 22 07:53 488449a2
      ```

  * Method 2: This method *only* works if there are no `Ready` images at the
    start of transferring the image. Using the REST API, note the object that
    has its Activation property set to Ready, in this example it'd be `2a1022fe`:

      ```
      $ curl -b cjar -k https://${bmc}/xyz/openbmc_project/software/enumerate
      {
        "data": {
          "/xyz/openbmc_project/software/2a1022fe": {
            "Activation": "xyz.openbmc_project.Software.Activation.Activations.Ready",
      ```

 * Method 3: Calculate the version id beforehand from the image with:

      ```
      tar xfO <UBI BMC tar image> MANIFEST | sed -ne '/version=/ {s/version=//;p}' | head -n1 | tr -d '\n' | sha512sum | cut -b 1-8
      ```


4. To initiate the update, set the `RequestedActivation` property of the desired
image to `Active`, substitute ``<id>`` with the hash value noted on the previous
step, this will write the contents of the image to a UBI volume in the BMC chip
via one of the following methods:

  * Method 1: From the BMC command line:

      ```
      busctl set-property xyz.openbmc_project.Software.BMC.Updater \
        /xyz/openbmc_project/software/<id> \
        xyz.openbmc_project.Software.Activation RequestedActivation s \
        xyz.openbmc_project.Software.Activation.RequestedActivations.Active

      ```

  * Method 2: Using the REST API:

      ```
      curl -b cjar -k -H "Content-Type: application/json" -X PUT \
        -d '{"data":
        "xyz.openbmc_project.Software.Activation.RequestedActivations.Active"}' \
        https://${bmc}/xyz/openbmc_project/software/<id>/attr/RequestedActivation
      ```

5. (Optional) Check the flash progress. This interface is only available during
the activation progress and is not present once the activation is completed
via one of the following:

  * Method 1: From the BMC command line:

      ```
      busctl get-property xyz.openbmc_project.Software.BMC.Updater  \
        /xyz/openbmc_project/software/<id> \
        xyz.openbmc_project.Software.Activation Progress
      ```

  * Method 2: Using the REST API:

      ```
      curl -b cjar -k https://${bmc}/xyz/openbmc_project/software/<id>/attr/Progress
      ```

6. Check that the activation is complete by verifying the "Activation" property
is set to "Active" via one of the following methods:

  * Method 1: From the BMC command line:

      ```
      busctl get-property xyz.openbmc_project.Software.BMC.Updater \
        /xyz/openbmc_project/software/<id> \
        xyz.openbmc_project.Software.Activation Activation
      ```

  * Method 2: Using the REST API:

      ```
      curl -b cjar -k https://${bmc}/xyz/openbmc_project/software/<id>
      ```

7. Reboot the BMC for the image to take effect.

  * Method 1: From the BMC command line:

      ```
      reboot
      ```

  * Method 2: Using the REST API:

      ```
      curl -c cjar -b cjar -k -H "Content-Type: application/json" -X PUT \
          -d '{"data": "xyz.openbmc_project.State.BMC.Transition.Reboot"}' \
          https://${bmc}/xyz/openbmc_project/state/bmc0/attr/RequestedBMCTransition
      ```

### Associations

In addition to all software images, several associations are listed at
`/xyz/openbmc_project/software/`:

```
curl -c cjar -b cjar -k -H "Content-Type: application/json" -X GET  \
    https://${bmc}/xyz/openbmc_project/software/
{
  "data": [
    "/xyz/openbmc_project/software/46e65782",
    "/xyz/openbmc_project/software/493a00ad",
    "/xyz/openbmc_project/software/88c153b1",
    "/xyz/openbmc_project/software/active",
    "/xyz/openbmc_project/software/functional"
  ],
  "message": "200 OK",
  "status": "ok"
}
```

1. A "functional" association to the "running" BMC and host images

There is only one functional association per BMC and one functional association per host.
The functional/running BMC image is the BMC image with the lowest priority when
rebooting the BMC. The functional image does not update until the BMC is rebooted.
The functional host image behaves the same way except that it updates on a
power on or reboot of the host.

```
curl -c cjar -b cjar -k -H "Content-Type: application/json" -X GET \
    https://${bmc}/xyz/openbmc_project/software/functional
{
  "data": {
    "endpoints": [
      "/xyz/openbmc_project/software/46e65782",
      "/xyz/openbmc_project/software/493a00ad"
    ]
  },
  "message": "200 OK",
  "status": "ok"
}
```

2. An "active" association to the active BMC and host images

Note: Several BMC images might be active, this is true for the host images
as well.

```
curl -c cjar -b cjar -k -H "Content-Type: application/json" -X GET \
    https://${bmc}/xyz/openbmc_project/software/active
{
  "data": {
    "endpoints": [
      "/xyz/openbmc_project/software/46e65782",
      "/xyz/openbmc_project/software/493a00ad",
      "/xyz/openbmc_project/software/88c153b1"
    ]
  },
  "message": "200 OK",
  "status": "ok"
}
```

An additional association is located at `/xyz/openbmc_project/software/<id>/inventory`
for "associating" a software image with an inventory item.

```
curl -c cjar -b cjar -k -H "Content-Type: application/json" -X GET \
   https://${bmc}/xyz/openbmc_project/software/493a00ad/inventory
{
  "data": {
    "endpoints": [
      "/xyz/openbmc_project/inventory/system/chassis/motherboard/boxelder/bmc"
    ]
  },
  "message": "200 OK",
  "status": "ok"
}
```

To get all software images associated with an inventory item:

```
curl -c cjar -b cjar -k -H "Content-Type: application/json" -X GET  \
    https://${bmc}/xyz/openbmc_project/inventory/system/chassis/activation
{
  "data": {
    "endpoints": [
      "/xyz/openbmc_project/software/46e65782"
    ]
  },
  "message": "200 OK",
  "status": "ok"
}
```

### Deleting an Image

To delete an image:

```
curl -c cjar -b cjar -k -H "Content-Type: application/json" \
    -X POST https://${bmc}/xyz/openbmc_project/software/<$id>/action/delete \
    -d "{\"data\": [] }"
```

Note: The image must be non-functional ("non-running").

To delete all non-functional images, whether BMC or host images:

```
curl -c cjar -b cjar -k -H "Content-Type: application/json" \
    -X POST https://${bmc}/xyz/openbmc_project/software/action/deleteAll \
    -d "{\"data\": [] }"
```



### Implementation

More information about the implementation of the UBI code update can be found at
https://github.com/openbmc/phosphor-dbus-interfaces/blob/master/xyz/openbmc_project/Software
and https://github.com/openbmc/phosphor-bmc-code-mgmt
