Host Code Update
================

Reference:
https://github.com/openbmc/phosphor-dbus-interfaces/blob/master/xyz/openbmc_project/Software

Following are the steps to update the host firmware (or "BIOS"). This assumes
the host is not accessing its firmware.

1. Get a squashfs image:
  * Build op-build: https://github.com/open-power/op-build
  * After building, the image should be a tarball in the output/images
    directory called <system type>.pnor.squashfs.tar

2. Transfer the generated squashfs image to the BMC via one of the following
methods:
  * Method 1: Via scp: Copy the generated squashfs image to the `/tmp/images/`
    directory on the BMC.
  * Method 2: Via REST Upload:
  https://github.com/openbmc/docs/blob/master/rest-api.md#uploading-images
  * Method 3: Via TFTP: Perform a POST request to call the `DownloadViaTFTP`
    method of `/xyz/openbmc_project/software`.

      ```
      curl -b cjar -k -H "Content-Type: application/json" -X POST \
        -d '{"data": ["<filename>", "<TFTP server IP address"]}' \
        https://${bmc}/xyz/openbmc_project/software/action/DownloadViaTFTP
      ```

3. Note the version id generated for that image file. The version id is a hash
value of 8 hexadecimal numbers, generated by SHA-512 hashing the version
string contained in the image and taking the first 8 characters. Get the
version id via one of the following methods:

  * Method 1: From the BMC command line, note the most recent directory name
    created under `/tmp/images/`, in this example it'd be `2a1022fe`:

      ```
      # ls -l /tmp/images/
      total 0
      drwx------    2 root     root            80 Aug 22 07:54 2a1022fe
      drwx------    2 root     root            80 Aug 22 07:53 488449a2
      ```

  * Method 2: This method *only* works if there are no `Ready` images at the
    start of transferring the image. Using the REST API, note the object that
    has its Activation property set to Ready, in this example it'd be `2a1022fe`:

      ```
      $ curl -b cjar -k https://${bmc}/xyz/openbmc_project/software/enumerate
      {
        "data": {
          "/xyz/openbmc_project/software/2a1022fe": {
            "Activation": "xyz.openbmc_project.Software.Activation.Activations.Ready",
      ```

  * Method 3: Calculate the version id beforehand from the image with:

      ```
      tar xfO <squashfs image tar> MANIFEST | sed -ne '/version=/ {s/version=//;p}' | head -n1 | tr -d '\n' | sha512sum | cut -b 1-8
      ```

4. To initiate the update, set the `RequestedActivation` property of the desired
image to `Active`, substitute ``<id>`` with the hash value noted on the previous
step, this will write the contents of the image to a UBI volume in the PNOR chip
via one of the following methods:

  * Method 1: From the BMC command line:

      ```
      busctl set-property org.open_power.Software.Host.Updater \
        /xyz/openbmc_project/software/<id> \
        xyz.openbmc_project.Software.Activation RequestedActivation s \
        xyz.openbmc_project.Software.Activation.RequestedActivations.Active

      ```

  * Method 2: Using the REST API:

      ```
      curl -b cjar -k -H "Content-Type: application/json" -X PUT \
        -d '{"data":
        "xyz.openbmc_project.Software.Activation.RequestedActivations.Active"}' \
        https://${bmc}/xyz/openbmc_project/software/<id>/attr/RequestedActivation
      ```

5. (Optional) Check the flash progress. This interface is only available during
the activation progress and is not present once the activation is completed
via one of the following:

  * Method 1: From the BMC command line:

      ```
      busctl get-property org.open_power.Software.Host.Updater \
        /xyz/openbmc_project/software/<id> \
        xyz.openbmc_project.Software.Activation Progress
      ```

  * Method 2: Using the REST API:

      ```
      curl -b cjar -k https://${bmc}/xyz/openbmc_project/software/<id>/attr/Progress
      ```

6. Check the activation is complete by verifying the Activation property is set
to Active via one of the following methods:

  * Method 1: From the BMC command line:

      ```
      busctl get-property org.open_power.Software.Host.Updater \
        /xyz/openbmc_project/software/<id> \
        xyz.openbmc_project.Software.Activation Activation
      ```

  * Method 2: Using the REST API:

      ```
      curl -b cjar -k https://${bmc}/xyz/openbmc_project/software/<id>
      ```

### Patching the host firmware

Copy the partition binary file to `/usr/local/share/pnor/` on the BMC.

The partition binary file must be named the same as the partition name that
intends to patch, ex: `ATTR_TMP`.
