SUMMARY = "Microsoft project for cloud-based client-server communication in native code using a modern asynchronous C++ API design."
SECTION = "libs/network"
HOMEPAGE = "https://github.com/Microsoft/cpprestsdk/"
LICENSE = "MIT"
LIC_FILES_CHKSUM = "file://${S}/license.txt;md5=a2e15b954769218ff912468eecd6a02f"
DEPENDS = "openssl websocketpp zlib boost brotli"

EXTRA_OECMAKE = "-DCPPREST_EXPORT_DIR=cmake -DCPPREST_EXCLUDE_BROTLI=OFF"

SRC_URI = "git://github.com/Microsoft/cpprestsdk.git;protocol=https;branch=master \
           file://disable-float-tests.patch \
           file://disable-outside-tests.patch "

# tag 2.10.13
SRCREV= "9d8f544001cb74544de6dc8c565592f7e2626d6e"

S = "${WORKDIR}/git"

inherit cmake pkgconfig

# Temporary until https://github.com/Microsoft/cpprestsdk/issues/1099
# is fixed properly
CXXFLAGS += "-Wno-error=deprecated-copy -Wno-error=redundant-move"
